(*| 16:35  4/03/1989 *)
PROGRAM TPComDef;

{$M $4000, 0, 0}{ 16k stack, no heap}

USES StdTypes,Dos;

CONST
  ExeDirOffset=$0D0;
  IncDirOffset=$118;
  UseDirOffset=$19C;
  ObjDirOffset=$220;
  ParamOffset =$2A4;
  StkSizOffset=$328;
  HeapLoOffset=$334;
  HeapHiOffset=$340;
  ExeNamOffset=$34C;
  ComDefOffset=$3A0;
  TabSizOffset=$424;
  PckFilOffset=$42C;
  TurDirOffset=$480;
  TPFileSize  =$4CA;

TYPE
  TPType = RECORD
                 ByteArray : ARRAY[0..(TPFileSize-1)] OF BYTE;
               END;

VAR
  TPFileName: LineString;
  TP: TPType;
  ComDefString: LineString;

PROCEDURE SetFileName(VAR TPFileName: LineString);
BEGIN
  IF ParamCount > 0 THEN
    TPFileName:=ParamStr(1) + '.TP'
  ELSE
    TPFileName:='TURBO.TP';
END;  { SetFileName }

PROCEDURE ReadTPFile(TPFileName: LineString; VAR TP: TPType);
VAR
  TPFile: FILE OF TPType;
BEGIN
  ASSIGN(TPFile,TPFileName);
{$I-}
  RESET(TPFile);
{$I+}
  IF IORESULT <> 0 THEN BEGIN
    WRITELN('Error opening file ',TPFileName);
    HALT;
  END;
  READ(TPFile,TP);
  CLOSE(TPFile);
END;  { ReadTPFile }

PROCEDURE GetTPString(TP: TPType; Offset: INTEGER;
                      VAR TPString: LineString);
VAR
  I: INTEGER;
  B: BYTE;
BEGIN
  TPString:='';
  I:=Offset;
  WITH TP DO BEGIN
    REPEAT
      B:=ByteArray[I];
      INC(I);
      IF B <> 0 THEN
        TPString:=TPString + CHR(B);
    UNTIL B=0;
  END;
END;

PROCEDURE GetComDef(TPFileName: LineString);
BEGIN
  ReadTPFile(TPFileName,TP);
  GetTPString(TP,ComDefOffset,ComDefString);
  WRITELN(TPFileName);
  WRITELN(ComDefString);
END;  { GetComDef }

PROCEDURE GetAllComDefs;
VAR
  FindRec: SearchRec;
BEGIN
  FindFirst('*.TP',AnyFile,FindRec);
  WHILE DosError=0 DO BEGIN
    GetComDef(FindRec.Name);
    FindNext(FindRec);
  END;
END;  { GetAllComDefs }

PROCEDURE Test;
BEGIN
  SetFileName(TPFileName);
  IF TPFileName='*.TP' THEN
    GetAllComDefs
  ELSE BEGIN
    GetComDef(TPFileName);
    IF ParamCount > 1 THEN
      IF ParamStr(2)='/C' THEN
        EXEC('C:\TURBO5\TP5C.EXE',ParamStr(1) + ' /B /D' + ComDefString);
  END;
END;

BEGIN
  Test;
END.
